/*
 * Decompiled with CFR 0.152.
 */
package me.angel.tridentrain;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import me.angel.tridentrain.CustomTridentEntity;
import me.angel.tridentrain.RainType;
import me.angel.tridentrain.commands.ChallengingRainCommand;
import me.angel.tridentrain.config.TridentRainConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1685;
import net.minecraft.class_1686;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8111;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tridentrain
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"challengingrain");
    private static TridentRainConfig config;
    private static boolean isTridentRainActive;
    private static int tickCounter;
    private static final Map<class_2338, Integer> placedAnvils;
    public static final int MAX_ANVIL_AGE = 200;
    private static final Set<UUID> spawnedEntities;
    private static final List<class_6880<class_1842>> AVAILABLE_POTIONS;

    public void onInitialize() {
        LOGGER.info("Challenging Rain mod has started up");
        config = TridentRainConfig.load();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ChallengingRainCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> !source.method_48793().method_40225(class_8111.field_42345) || !spawnedEntities.contains(entity.method_5667()));
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> spawnedEntities.remove(entity.method_5667()));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (isTridentRainActive && ++tickCounter >= config.getSpawnFrequency()) {
                tickCounter = 0;
                server.method_3760().method_14571().forEach(player -> {
                    if (player.method_51469() instanceof class_3218) {
                        Tridentrain.spawnTridentsAroundPlayer(player.method_51469(), player);
                    }
                });
            }
            server.method_3738().forEach(world -> {
                Iterator<Map.Entry<class_2338, Integer>> it = placedAnvils.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<class_2338, Integer> entry = it.next();
                    class_2338 pos = entry.getKey();
                    if (!world.method_8393(pos.method_10263() >> 4, pos.method_10260() >> 4)) continue;
                    int age = entry.getValue() + 1;
                    if (age >= 200 && config.isAnvilDiscarding()) {
                        class_2680 state = world.method_8320(pos);
                        if (state.method_27852(class_2246.field_10535)) {
                            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                        }
                        it.remove();
                        continue;
                    }
                    entry.setValue(age);
                }
            });
        });
    }

    public static void trackPlacedAnvil(class_2338 pos) {
        if (isTridentRainActive && config.getCurrentRainType() == RainType.ANVIL) {
            placedAnvils.put(pos, 0);
        }
    }

    public static void spawnTridentsAroundPlayer(class_3218 world, class_3222 player) {
        Random random = new Random();
        for (int i = 0; i < config.getTridentsPerTick(); ++i) {
            double x = player.method_23317() + (random.nextDouble() * 2.0 - 1.0) * config.getSpawnRadius();
            double y = player.method_23318() + (double)config.getFallHeight();
            double z = player.method_23321() + (random.nextDouble() * 2.0 - 1.0) * config.getSpawnRadius();
            Tridentrain.spawnRainEntity(world, x, y, z, player.method_36454(), player.method_36455());
        }
    }

    public static void spawnRainEntity(class_3218 world, double x, double y, double z, float yaw, float pitch) {
        switch (Tridentrain.getCurrentRainType()) {
            case ANVIL: {
                class_2680 anvilState;
                class_1540 anvil;
                int minSpawnY;
                class_2338 playerPos = new class_2338((int)x, (int)(y - (double)config.getFallHeight()), (int)z);
                class_2338 spawnPos = null;
                int MIN_SAFE_HEIGHT = 3;
                for (int checkY = minSpawnY = playerPos.method_10264() + 3; checkY <= playerPos.method_10264() + config.getFallHeight(); ++checkY) {
                    class_2338 checkPos = new class_2338((int)x, checkY, (int)z);
                    class_2680 checkState = world.method_8320(checkPos);
                    if (checkState.method_26215()) {
                        spawnPos = checkPos;
                        continue;
                    }
                    if (spawnPos != null) break;
                }
                if (spawnPos == null) {
                    spawnPos = new class_2338((int)x, (int)y, (int)z);
                }
                if ((anvil = class_1540.method_40005((class_1937)world, (class_2338)spawnPos, (class_2680)(anvilState = (class_2680)class_2246.field_10535.method_9564().method_11657((class_2769)class_2199.field_9883, (Comparable)class_2350.class_2353.field_11062.method_10183(world.method_8409()))))) == null) break;
                anvil.field_7193 = false;
                anvil.field_7192 = 1;
                anvil.method_5665((class_2561)class_2561.method_43470((String)"tridentrain_anvil"));
                if (!config.isExplosiveAnvils() || !(world.method_8409().method_43057() < config.getExplosionChance())) break;
                anvil.method_5665((class_2561)class_2561.method_43470((String)"explosive"));
                break;
            }
            case ENTITY: {
                int entityMinSpawnY;
                class_2338 entityPlayerPos = new class_2338((int)x, (int)(y - (double)config.getFallHeight()), (int)z);
                class_2338 entitySpawnPos = null;
                int ENTITY_MIN_SAFE_HEIGHT = 3;
                for (int checkY = entityMinSpawnY = entityPlayerPos.method_10264() + 3; checkY <= entityPlayerPos.method_10264() + config.getFallHeight(); ++checkY) {
                    class_2338 checkPos = new class_2338((int)x, checkY, (int)z);
                    class_2680 checkState = world.method_8320(checkPos);
                    if (checkState.method_26215()) {
                        entitySpawnPos = checkPos;
                        continue;
                    }
                    if (entitySpawnPos != null) break;
                }
                if (entitySpawnPos == null) {
                    entitySpawnPos = new class_2338((int)x, (int)y, (int)z);
                }
                try {
                    class_2960 entityId;
                    Optional optionalEntityType;
                    Object entityTypeStr = config.getEntityType();
                    if (!((String)entityTypeStr).contains(":")) {
                        entityTypeStr = "minecraft:" + (String)entityTypeStr;
                    }
                    if ((optionalEntityType = class_7923.field_41177.method_17966(entityId = class_2960.method_60654((String)entityTypeStr))).isPresent()) {
                        class_1299 entityType = (class_1299)optionalEntityType.get();
                        class_1297 entity = entityType.method_47821(world, entitySpawnPos, class_3730.field_16467);
                        if (entity != null) {
                            entity.method_5880(false);
                            spawnedEntities.add(entity.method_5667());
                            if (entity instanceof class_1309) {
                                class_1309 livingEntity = (class_1309)entity;
                                livingEntity.method_6092(new class_1293(class_1294.field_5906, 600, 0, false, false, true));
                                livingEntity.field_6017 = 0.0;
                                livingEntity.field_6008 = 60;
                            }
                            try {
                                Random random = new Random();
                                double velocityX = random.nextDouble() * 0.2 - 0.1;
                                double velocityZ = random.nextDouble() * 0.2 - 0.1;
                                double velocityY = -0.2 - random.nextDouble() * 0.3;
                                entity.method_18800(velocityX, velocityY, velocityZ);
                                entity.field_6037 = true;
                                LOGGER.debug("Applied initial velocity to entity: {}", (Object)entity.getClass().getSimpleName());
                            }
                            catch (Exception e) {
                                LOGGER.warn("Could not apply velocity to entity type: {} - {}", (Object)entity.getClass().getSimpleName(), (Object)e.getMessage());
                            }
                            break;
                        }
                        LOGGER.error("Failed to spawn entity: {}", entityTypeStr);
                        break;
                    }
                    LOGGER.error("Unknown entity type: {}", entityTypeStr);
                }
                catch (Exception e) {
                    LOGGER.error("Error spawning entity: {}", (Object)e.getMessage());
                }
                break;
            }
            case POTION: {
                int potionMinSpawnY;
                class_2338 potionPlayerPos = new class_2338((int)x, (int)(y - (double)config.getFallHeight()), (int)z);
                class_2338 potionSpawnPos = null;
                int POTION_MIN_SAFE_HEIGHT = 3;
                for (int checkY = potionMinSpawnY = potionPlayerPos.method_10264() + 3; checkY <= potionPlayerPos.method_10264() + config.getFallHeight(); ++checkY) {
                    class_2338 checkPos = new class_2338((int)x, checkY, (int)z);
                    class_2680 checkState = world.method_8320(checkPos);
                    if (checkState.method_26215()) {
                        potionSpawnPos = checkPos;
                        continue;
                    }
                    if (potionSpawnPos != null) break;
                }
                if (potionSpawnPos == null) {
                    potionSpawnPos = new class_2338((int)x, (int)y, (int)z);
                }
                try {
                    Random random = new Random();
                    class_6880<class_1842> selectedPotion = AVAILABLE_POTIONS.get(random.nextInt(AVAILABLE_POTIONS.size()));
                    int maxAmplifier = config.getMaxPotionAmplifier();
                    int potionLevel = random.nextInt(maxAmplifier + 1);
                    class_1799 potionItem = new class_1799((class_1935)class_1802.field_8436);
                    if (potionLevel == 0) {
                        potionItem.method_57379(class_9334.field_49651, (Object)new class_1844(selectedPotion));
                    } else {
                        ArrayList<class_1293> customEffects = new ArrayList<class_1293>();
                        for (class_1293 baseEffect : ((class_1842)selectedPotion.comp_349()).method_8049()) {
                            customEffects.add(new class_1293(baseEffect.method_5579(), baseEffect.method_5584(), potionLevel, false, true, true));
                        }
                        class_1844 customPotion = new class_1844(Optional.empty(), Optional.empty(), customEffects, Optional.empty());
                        potionItem.method_57379(class_9334.field_49651, (Object)customPotion);
                    }
                    class_1686 potionEntity = (class_1686)class_1299.field_56254.method_47821(world, potionSpawnPos, class_3730.field_16467);
                    if (potionEntity == null) break;
                    potionEntity.method_16940(potionItem);
                    potionEntity.method_18800(random.nextDouble() * 0.2 - 0.1, -0.3 - random.nextDouble() * 0.2, random.nextDouble() * 0.2 - 0.1);
                    potionEntity.method_5665((class_2561)class_2561.method_43470((String)"challengingrain_potion"));
                    potionEntity.method_5880(false);
                    String levelText = potionLevel == 0 ? "base" : "level " + (potionLevel + 1);
                    LOGGER.debug("Spawned splash potion: {} ({})", (Object)class_7923.field_41179.method_10221((Object)((class_1842)selectedPotion.comp_349())), (Object)levelText);
                }
                catch (Exception e) {
                    LOGGER.error("Error spawning potion: {}", (Object)e.getMessage());
                }
                break;
            }
            default: {
                CustomTridentEntity trident = new CustomTridentEntity((class_1299<? extends class_1685>)class_1299.field_6127, (class_1937)world);
                trident.method_5814(x, y, z);
                trident.method_18800(Math.sin(-yaw * ((float)Math.PI / 180)) * Math.cos(pitch * ((float)Math.PI / 180)) * config.getMaxSpeed(), -Math.sin(pitch * ((float)Math.PI / 180)) * config.getMaxSpeed(), Math.cos(-yaw * ((float)Math.PI / 180)) * Math.cos(pitch * ((float)Math.PI / 180)) * config.getMaxSpeed());
                world.method_8649((class_1297)trident);
            }
        }
    }

    public static boolean toggleTridentRain() {
        isTridentRainActive = !isTridentRainActive;
        return isTridentRainActive;
    }

    public static void setIntensity(int level) {
        config.applyIntensity(level);
        config.save();
    }

    public static void setFallHeight(int height) {
        config.setFallHeight(height);
    }

    public static void setSpawnRadius(double radius) {
        config.setSpawnRadius(radius);
    }

    public static void setMaxAngle(double angle) {
        config.setMaxAngle(angle);
    }

    public static void setMinAngle(double angle) {
        config.setMinAngle(angle);
    }

    public static void resetToDefaults() {
        config.resetToDefaults();
    }

    public static TridentRainConfig getConfig() {
        return config;
    }

    public static boolean isActive() {
        return isTridentRainActive;
    }

    public static boolean toggleBlockBreaking() {
        config.setBlockBreaking(!config.isBlockBreaking());
        return config.isBlockBreaking();
    }

    public static void setBlockBreaking(boolean enabled) {
        config.setBlockBreaking(enabled);
    }

    public static boolean isBlockBreakingEnabled() {
        return config.isBlockBreaking();
    }

    public static void setRainType(RainType type) {
        config.setRainType(type);
    }

    public static RainType getCurrentRainType() {
        return config.getCurrentRainType();
    }

    public static boolean toggleExplosiveAnvils() {
        config.setExplosiveAnvils(!config.isExplosiveAnvils());
        return config.isExplosiveAnvils();
    }

    public static void setExplosiveAnvils(boolean enabled) {
        config.setExplosiveAnvils(enabled);
    }

    public static boolean isExplosiveAnvilsEnabled() {
        return config.isExplosiveAnvils();
    }

    public static void setExplosionChance(float chance) {
        config.setExplosionChance(chance);
    }

    public static float getExplosionChance() {
        return config.getExplosionChance();
    }

    public static boolean toggleAnvilDiscarding() {
        config.setAnvilDiscarding(!config.isAnvilDiscarding());
        return config.isAnvilDiscarding();
    }

    public static void setAnvilDiscarding(boolean enabled) {
        config.setAnvilDiscarding(enabled);
    }

    public static boolean isAnvilDiscardingEnabled() {
        return config.isAnvilDiscarding();
    }

    public static void setEntityType(String entityType) {
        config.setEntityType(entityType);
    }

    public static String getEntityType() {
        return config.getEntityType();
    }

    public static void setMaxPotionAmplifier(int amplifier) {
        config.setMaxPotionAmplifier(amplifier);
    }

    static {
        isTridentRainActive = false;
        tickCounter = 0;
        placedAnvils = new HashMap<class_2338, Integer>();
        spawnedEntities = new HashSet<UUID>();
        AVAILABLE_POTIONS = new ArrayList<class_6880<class_1842>>();
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8968);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8997);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8979);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8987);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_9005);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8996);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8994);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8963);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_9004);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8982);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8986);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8978);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8975);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8995);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8974);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_8990);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_50155);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_50154);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_50153);
        AVAILABLE_POTIONS.add((class_6880<class_1842>)class_1847.field_50156);
    }
}

